/* try to detect which videos have audio tracks and add class has_audio to them */

(function() {
  'use strict';

  // discover if this browser supports audioTracks
  var audio_tracks_available = null;
  function detect_audio_tracks(video) {
    if (typeof(video.audioTracks) !== 'undefined') {
      audio_tracks_available = true;
    }
    else {
      audio_tracks_available = false;
    }
  }

  // discover if this browser supports hasAudio
  var has_audio_property;
  var has_audio_available = null;
  function detect_has_audio(video) {
    if (typeof video.hasAudio !== 'undefined') {
      has_audio_property = 'hasAudio';
      has_audio_available = true;
    }
    else if (typeof video.mozHasAudio !== 'undefined') {
      has_audio_property = 'mozHasAudio';
      has_audio_available = true;
    }
    else {
      has_audio_available = false;
    }
  }

  // discover if this browser supports audioDecodedByteCount
  var audio_decoded_byte_count_property;
  var audio_decoded_byte_count_available = null;
  function detect_audio_decoded_byte_count(video) {
    if (typeof video.webkitAudioDecodedByteCount !== 'undefined') {
      audio_decoded_byte_count_available = true;
      audio_decoded_byte_count_property = 'webkitAudioDecodedByteCount';
    }
    else {
      audio_decoded_byte_count_available = false;
    }
  }

  function check_audio(video) {
    /* check whether this video has audio, defaulting to true if it can't be
     * determined */

    // through audioTracks
    if (audio_tracks_available === null) { detect_audio_tracks(video); }
    if (audio_tracks_available) {
      return (video.audioTracks.length === 0);
    }

    // through hasAudio
    if (has_audio_available === null) { detect_has_audio(video); }
    if (has_audio_available) {
      return video[has_audio_property];
    }

    // through audioDecodedByteCount
    if (audio_decoded_byte_count_available === null) { detect_audio_decoded_byte_count(video); }
    if (audio_decoded_byte_count_available) {
      return (video[audio_decoded_byte_count_property] > 0);
    }

    return true;
  }

  function first_play_handler() {
    /* check video for audio and mark it accordingly (also display its unmute
     * link if it exists) */
    /* jshint validthis:true */

    this.removeEventListener('play', first_play_handler);

    if (check_audio(this)) {
      this.classList.add('has_audio');

      // unhide unmute link, if it exists
      var num = /\d+$/.exec(this.getAttribute('id'));
      var link =  document.getElementById('unmute'+num);
      if (link) {
        link.classList.remove('hidden');
      }
    }
  }

  function setup() {
    var i, videos = document.getElementsByTagName('video');
    for (i=0; i < videos.length; i++) {
      // skip videos we already know have audio
      if (videos[i].classList.contains('has_audio')) {
        continue;
      }
      /* we must wait until the video has loaded enough for the browser to know
       * about its audio track */
      videos[i].addEventListener('play', first_play_handler);
    }
  }

  document.addEventListener('DOMContentLoaded', setup);
}());
