#! /usr/bin/env python3
'''Request router'''

from os.path import join, exists

from flask import abort, send_file, send_from_directory, redirect

from .flask_app import app
from .common import app_dir
from .blog import Router as BlogRouter
from .album import Album


_blog_router = BlogRouter()


@app.route('/')
def serve_index():
    '''Serve the index page.'''
    page_path = join(app_dir, 'static', 'pages', 'index.html')
    return send_file(page_path)


@app.route('/static/<filename>')
@app.route('/static/<path:subpath>/<filename>')
@app.route('/robots.txt',
           defaults={'subpath': 'files', 'filename': 'robots.txt'})
@app.route('/favicon.ico',
           defaults={'subpath': 'files', 'filename': 'favicon.ico'})
def serve_static_files(filename=None, subpath=None):
    '''Static files'''
    dir_path = join(app_dir, 'static')
    if subpath:
        dir_path = join(dir_path, subpath)
        if not exists(dir_path):
            abort(404)

    return send_from_directory(dir_path, filename)


@app.route('/a/')
@app.route('/a/<path:url_list>')
def redirect_album_page(url_list=None):
    '''Redirect a shortened album url.'''
    return redirect(f'/album/{url_list or ""}', 301)


@app.route('/album/')
@app.route('/album/<path:url_list>')
def serve_album_page(url_list=None):
    '''Route album request'''
    return Album.get(url_list)


@app.route('/<path:path>', methods=['GET', 'POST'])
def serve_blog_page(path):
    '''Route blog request'''
    # NOTE that we have to re-add the initial slash
    return _blog_router.get(f'/{path}')
