#!/usr/bin/env python3
'''Logging'''
# pylint: disable = unused-import

import logging
from logging import DEBUG, INFO, WARNING, ERROR


# create and configure a base logger, which other modules can inherit from by
# calling logging.getLogger('loopvid.<something>')
formatter = logging.Formatter(fmt='*** %(asctime)s %(levelname)s %(message)s',
                              datefmt='%Y-%m-%d %H:%M:%S')

handler = logging.StreamHandler()
handler.setFormatter(formatter)

logger = logging.getLogger('loopvid')
logger.addHandler(handler)

logger.setLevel(WARNING)

error = logger.error
warning = logger.warning
info = logger.info
debug = logger.debug
