CREATE TABLE post (
    post_id INTEGER PRIMARY KEY NOT NULL,

    source_id INTEGER REFERENCES source NOT NULL,

    name TEXT UNIQUE NOT NULL,

    posted_at TEXT NOT NULL,

    views INTEGER DEFAULT 0
);
CREATE INDEX post_idx1 ON post(posted_at);


CREATE TABLE source (
    source_id INTEGER PRIMARY KEY NOT NULL,

    title TEXT UNIQUE NOT NULL,
    url TEXT UNIQUE,

    -- primary shortlink
    shortlink TEXT UNIQUE NOT NULL,
    url_shortlink TEXT
);


CREATE TABLE alt_shortlink (
    alt_shortlink_id INTEGER PRIMARY KEY NOT NULL,

    source_id INTEGER REFERENCES source ON DELETE CASCADE NOT NULL,
    value TEXT UNIQUE NOT NULL
);
CREATE INDEX alt_shortlink_idx1 ON alt_shortlink (source_id);


CREATE TABLE tag (
    tag_id INTEGER PRIMARY KEY NOT NULL,

    post_id INTEGER REFERENCES post ON DELETE CASCADE NOT NULL,

    value TEXT NOT NULL,

    UNIQUE (post_id, value)
);
CREATE INDEX tag_idx1 ON tag (post_id);
CREATE INDEX tag_idx2 ON tag (value);
